// FadeObject.js by Radnen

/*
	This is the fade object function. It is used on images
	that are needed to be faded in and slide across the screen.
	
	Now you can add images and text to these images
*/
function DynaImage(filename)
{
	// defaults:
	this.img = LoadImage(filename);
	this.fadeStop = 255;
	this.fade = false;
	this.fade_type = "in";
	this.x = 0; this.y = 0; this.z = 1;
	this.xv = 0; this.yv = 0; this.zv = 0;
	this.newX = 0; this.newY = 0; this.newZ = 1;
	this.yamt = 1; this.xamt = 1;
	this.newFade = 255;
	this.originalFade = 255;
	this.fadev = 255;
	this.color = CreateColor(255, 255, 255); // colormask for fading
	this.time = GetTime();
	this.started = false;
	this.looped = false;
	this.loopFade = false;
	this.width = this.img.width;
	this.height = this.img.height;
	this.strings = [];
	this.images = [];
}

DynaImage.prototype.addText = function(x, y, font, string, size, color)
{
	if (size == undefined) size = 1;
	if (color == undefined) color = CreateColor(255, 255, 255);
	var str = {};
	str.x = x;
	str.y = y;
	str.font = font;
	str.size = size;
	str.color = color;
	str.text = string;
	this.strings.push(str);
}

DynaImage.prototype.addImage = function(x, y, img, size, color)
{
	if (size == undefined) size = 1;
	if (color == undefined) color = CreateColor(255, 255, 255);
	var img = {};
	img.x = x;
	img.y = y;
	img.size = size;
	img.color = color;
	img.img = img;
	this.images.push(img);
}

DynaImage.prototype.slideFrom = function(x1, y1)
{
	this.x = x1;
	this.y = y1;
	this.xv = x1;
	this.yv = y1;
}

DynaImage.prototype.slideTo = function(x2, y2)
{
	this.newX = x2;
	this.newY = y2;
}

DynaImage.prototype.fadeStop = function(num)
{
	this.fadeStop = num;
}

DynaImage.prototype.fadeImage = function(type)
{
	this.fade = true;
	this.fade_type = type;
	this.started = false;
}

// This is used to slide the image over time //
DynaImage.prototype.update = function(msecs)
{
	if (!this.started)
	{
		this.started = true;
		this.time = GetTime();
	}
	
	if (this.time + msecs > GetTime())
	{
		if (this.fade)
		{
			if (this.fade_type == "in") this.color.alpha = (GetTime() - this.time) * this.fadeStop / msecs;
			if (this.fade_type == "out") this.color.alpha = 255 - (GetTime() - this.time) * this.fadeStop / msecs;
		}
		this.blit(this.xv, this.yv, this.color);
		
		if (this.newX > this.x) this.xv = this.x + (GetTime() - this.time) * (this.newX-this.x) / msecs;
		if (this.newX < this.x) this.xv = this.x - (GetTime() - this.time) * (this.x-this.newX) / msecs;
		if (this.newY > this.y) this.yv = this.y + (GetTime() - this.time) * (this.newY-this.y) / msecs;
		if (this.newY < this.y) this.yv = this.y - (GetTime() - this.time) * (this.y-this.newY) / msecs;
	}
	else if (this.looped)
	{
		this.blit(this.xv, this.yv, this.color);
		this.started = false;
		if (this.loopFade)
		{
			if (this.fade_type == "in") this.fade_type = "out";
			else this.fade_type = "in";
		}
	}
	else this.blit(this.newX, this.newY, this.color);
}

DynaImage.prototype.zoomOut = function(newX, newY, newZ, msecs)
{
	var bg = GrabImage(0, 0, SW, SH);
	var time = GetTime();
	this.newZ = newZ;
	this.newX = newX; this.newY = newY;
	with(this)
	{
		while(time + msecs > GetTime())
		{
			bg.blit(0, 0);
			if (newZ > z) zv = z + (GetTime() - time) * (newZ-z) / msecs;
			if (newZ < z) zv = z - (GetTime() - time) * (z-newZ) / msecs;
			if (newX > x) xv = x + (GetTime() - time) * (newX-x) / msecs;
			if (newX < x) xv = x - (GetTime() - time) * (x-newX) / msecs;
			if (newY > y) yv = y + (GetTime() - time) * (newY-y) / msecs;
			if (newY < y) yv = y - (GetTime() - time) * (y-newY) / msecs;
			img.zoomBlit(xv, yv, zv);
			FlipScreen();
		}
		bg.blit(0, 0);
		img.zoomBlit(newX, newY, newZ);
	}
}

DynaImage.prototype.blit = function(x, y, color)
{
	if (color == undefined) color = CreateColor(255, 255, 255);
	this.img.blitMask(x, y, color);
	for (var i = 0; i < this.strings.length; ++i)
	{
		var old_col = this.strings[i].font.getColorMask();
		this.strings[i].font.setColorMask(color);
		this.strings[i].font.drawZoomedText(x+this.strings[i].x, y+this.strings[i].y, this.strings[i].size, this.strings[i].text);
		this.strings[i].font.setColorMask(old_col);
	}
	for (var i = 0; i < this.images.length; ++i)
	{
		this.images[i].img.blit(x+this.images[i].x, y+this.images[i].y);
	}
}

DynaImage.prototype.zoomBlit = function(x, y, z)
{
	this.img.zoomBlit(x, y, z);
}

DynaImage.prototype.clone = function()
{
	var i;
	var temp_obj = new Object;
	for (i in this){temp_obj[i] = this[i];}
	return temp_obj;
}

DynaImage.prototype.reset = function()
{
	with(this)
	{
		newX = 0; newY = 0;
		x = 0; y = 0;
		yv = 0; xv = 0;
		fadev = 255;
		newFade = 255;
		looped = false;
		loopFade = false;
	}
}

DynaImage.prototype.fadeIn = function(msecs)
{
	var bg = GrabImage(0, 0, SW, SH);
	var time = GetTime();
	while(time + msecs > GetTime())
	{
		bg.blit(0, 0);
		this.color.alpha = (GetTime() - time) * this.fadeStop / msecs;
		this.img.blitMask(this.x, this.y, this.color);
		FlipScreen();
	}
	bg.blit(0, 0);
	this.img.blitMask(this.x, this.y, this.color);
}

DynaImage.prototype.setXY = function(x, y)
{
	this.slideFrom(x, y);
	this.newX = x;
	this.newY = y;
}

function PlaySlideImageArray(array,msecs) // will play all slide images in an array.
{
	var bg = GrabImage(0,0,SW,SH);
	var time = GetTime();
	while(time + msecs > GetTime())
	{
		bg.blit(0,0);
		var i = array.length-1;
		do
		{
			with(array[i])
			{
				if (fade)
				{
					if (fade_type == "in") color.alpha = (GetTime() - time) * fadeStop / msecs;
					if (fade_type == "out") color.alpha = 255 - (GetTime() - time) * fadeStop / msecs;
				}
				img.blitMask(xv,yv,color);
				if (newX > x) xv = x + (GetTime() - time) * (newX-x) / msecs;
				if (newX < x) xv = x - (GetTime() - time) * (x-newX) / msecs;
				if (newY > y) yv = y + (GetTime() - time) * (newY-y) / msecs;
				if (newY < y) yv = y - (GetTime() - time) * (y-newY) / msecs;
			}
		}while(i--);
		FlipScreen();
	}
	bg.blit(0,0);
	i = array.length-1;
	do
	{
		with(array[i]) {img.blitMask(xv,yv,color);}
	}while(i--);
}


//---===Blinking Image===---//
/*
	This is used for arrows and text that need to blink
	and not block other processes, their drawing is
	completely dependent on time.
*/
function BlinkImg(img,x,y)
{
	var now = new Date();
	if (now.getMilliseconds() < 500) img.blit(x,y);
}

function BlinkTxt(txt,x,y)
{
	var now = new Date();
	if (now.getMilliseconds() < 500) font.drawText(x,y,txt);
}